const { cart, product } = require('./selectors');
const addCatalogProductToCart = require('./utils/addCatalogProductToCart');

module.exports = function checkAnonymousCart(browser, catalogPath, cartPath) {
  catalogPath = `${catalogPath}?filters[variants.availability.isOnStock]=1`;
  let cookies;

  // Create testing customer.
  const mail = 'commercetools-test-user@example.com';
  const name = 'commercetools-test-user';
  browser.perform(async () => {
    await browser.thCreateUser({ mail, name });
  });

  const checkCart = (empty = false, context = '') => {
    if (context) {
      browser.perform(() => {
        browser.testHelpersHttpMockSetSettings({ context });
      });
    }

    const selector = empty ? cart.emptyText : cart.lineItems;
    browser // eslint-disable-line no-unused-expressions
      .drupalRelativeURL(cartPath)
      .waitForElementVisible(cart.component)
      .expect.element(selector).to.be.present;
  };

  browser
    // Ensure that anonymous cart is empty.
    .perform(() => {
      checkCart(true);
    })
    // Add a product to the cart.
    .drupalRelativeURL(catalogPath)
    .waitForElementVisible(product.cards)
    .perform(() => {
      addCatalogProductToCart(browser);
    })
    // The cart should not be empty after adding products.
    .perform(() => {
      checkCart(false, 'Cart with products');
    })
    // Delete all cookies created after adding an item to the cart.
    .perform(async () => {
      cookies = await browser.cookies.getAll();
      cookies.forEach((cookie) => {
        if (cookie.name !== 'SIMPLETEST_USER_AGENT') {
          browser.cookies.delete(cookie.name);
        }
      });
    })
    // The cart should be empty after removing session cookies.
    .perform(() => {
      checkCart(true, 'Remove session cookies');
    })
    // Return all cookies back after checking.
    .perform(() => {
      cookies.forEach((cookie) => {
        if (cookie.name !== 'SIMPLETEST_USER_AGENT') {
          browser.cookies.set(cookie);
        }
      });
    })
    // Log in as a new user.
    .perform(() => {
      browser.thLogin(name);
    })
    // The cart of a new user should be empty.
    .perform(() => {
      checkCart(true, 'Cart of a logged user');
    });
};
