const { order } = require('./selectors');

async function checkOrderCard(browser, item, index) {
  const titleEl = {
    selector: order.card.title,
    index,
  };
  const priceEl = {
    selector: order.card.price,
    index,
  };
  const stateEl = {
    selector: order.card.state,
    index,
  };
  const lineItemsEl = {
    selector: order.card.lineItems,
    index,
  };

  const subTotal = item.lineItems.reduce(
    (carry, lineItem) => {
      carry.centAmount += lineItem.totalPrice.centAmount;
      return carry;
    },
    { ...item.totalPrice, ...{ centAmount: 0 } },
  );
  await browser.assert.textContains(
    titleEl,
    `#${item.orderNumber}`,
    `Checking the order title in the item ${index}`,
  );

  await browser.assert.textContains(
    priceEl,
    new Intl.NumberFormat('en', {
      style: 'currency',
      currency: subTotal.currencyCode,
    }).format(subTotal.centAmount / 10 ** subTotal.fractionDigits),
    `Checking the order price in the item ${index}`,
  );

  await browser.assert.textContains(
    stateEl,
    item.orderState,
    `Checking the order state in the item ${index}`,
  );

  await browser.assert.elementPresent(
    lineItemsEl,
    `Checking the order line items in the item ${index}`,
  );
}

module.exports = checkOrderCard;
