function checkSubscriptionsWebhook(browser) {
  const endpoint = '/api/commercetools/webhook/subscriptions';

  browser.thDrupalFetchURL(
    endpoint,
    'POST',
    JSON.stringify({
      message: [
        {
          body: JSON.stringify({
            resource: { typeId: 'product', id: '12345' },
          }),
        },
        {
          body: JSON.stringify({
            resource: { typeId: 'category', id: '98765' },
          }),
        },
      ],
    }),
    (result) => {
      browser.assert.equal(JSON.parse(result.value.body).status, 'success');
    },
  );
}

module.exports = checkSubscriptionsWebhook;
