const assert = require('node:assert/strict');
const {
  product: { card },
} = require('./selectors');
const getResponseFromLatestByDataType = require('./getResponseFromLatestByDataType');

module.exports = async function getSomeProduct(
  browser,
  catalogPagePath,
  callback,
) {
  const dataType = 'productProjectionSearch';

  let product;
  await browser
    .drupalRelativeURL(catalogPagePath)
    .waitForElementVisible(card.component);
  await getResponseFromLatestByDataType(browser, dataType, (response) => {
    const result = response.value.value;
    [product] = result.data[dataType].results;
    assert.notEqual(product.id, undefined);

    // @todo Remove this crutch when the query is fixed.
    if (dataType === 'products') {
      const productId = product.id;
      product = product.masterData.current;
      product.id = productId;
    }
  });
  if (typeof callback === 'function') {
    const self = this;
    await callback.call(self, {
      status: 0,
      value: product,
    });
  }
  return product;
};
