/**
 * Checks if a named parameter is presented in the current URL.
 *
 * @param {object} browser
 *   The Nightwatch browser instance.
 * @param {string} param
 *   A URL parameter name to check.
 * @param {*} value
 *   A parameter value to compare if provided.
 */
module.exports = function checkUrlContainsParam(browser, param, value = null) {
  browser.getCurrentUrl((result) => {
    const params = new URL(result.value).searchParams;
    if (value) {
      browser.assert.equal(
        params.get(param),
        value,
        `The current URL contains the expected '${param}' parameter equal to '${value}'.`,
      );
    } else {
      browser.assert.ok(
        params.has(param),
        `The current URL contains the expected '${param}' parameter.`,
      );
    }
  });
};
