# commercetools

The commercetools module provides a lightweight integration between Drupal CMS
and [commercetools](https://commercetools.com/) that works out of the box
without much special configuration, providing a full-featured e-commerce
solution on your Drupal website.

To get the fully working e-commerce you need to just enter the commercetools
credentials in the module settings and that’s it!

With this integration, your website gets a full-featured online store with
multi-language, multi-country, multi-currency, multiple stocks, checkout,
payments, order management, and all other modern e-commerce features.

All the products, clients, and PII data are stored on the commercetools side, no
data is stored permanently on the Drupal side, eliminating the need to store PII
data in a special way, and keeping your Drupal database compact and lightweight.

The commercetools data, required to render the product pages, is cached locally
on the Drupal side with instant invalidation using commercetools Subscriptions.

Products, product listings and filters can be integrated into any Drupal webpage
using native Drupal Blocks and Layout Builder layouts.

## Live demo

You can check out a live demo directly in the browser using this link:
- [Open Live Demo »](https://simplytest.me/project/commercetools_online_demo)

Just click a button "Launch Sandbox" there, and get the working website.

Also, the module includes a `commercetools_demo` submodule that demonstrates the
full multi-language e-commerce functionality directly on your local setup,
without requiring a commercetools account or any other registration.

It provides several commercetools accounts with demo data to demonstrate B2C and
B2B types of e-commerce. To test, just open the "Demo" tab in the module
settings and deploy the content or decoupled module, or even both at once!

## Submodules

The module provides two approaches to render the commercetools data:

### Coupled approach: `commercetools_content` submodule

This approach renders all the data on the backend and deliver a full
pre-rendered page to the frontend, providing the best performance for the first
page load.

### Decoupled approach  `commercetools_decoupled` submodule

The decoupled approach provides a frontend rendering feature, where the backend
prepares interactive components, that loads the data on the frontend using
GraphQL queries.

This approach provides better performance with in-page interactions like
browsing the catalog and filtering.

Web Components, provided by this module are implemented independently and can be
integrated into any SPA (single-page application) framework: React, Vue.js,
Angular, etc.


## Installation and configuration

Install it just as a regular Drupal Module, the module requires no dependencies.

Then, the module configuration will be available in the admin panel:
Configuration » commercetools (`/admin/config/system/commercetools`) - you
should enter there your commercetools credentials: Client ID, Client secret,
Project key, and that's it, it should start working. [Register a free
commercetools account »](https://commercetools.com/free-trial)

If you have no commercetools credentials yet, just enable the demo submodule to
test the functionality out of the box, without any registrations.

The main module `commercetools` provides the base functionality with no UI, to
get the end user UI you should install one of the UI modules:
`commercetools_content` or `commercetools_decoupled`.

The templates uses Bootstrap classes for design by default, to provide a good
looking design out of the box. But Bootstrap dependency is not required, you can
easily override the provided templates to use your own design library.


### Cache configuration

The module caches the data received from commercetools to improve the site
performance. By default the module uses a Drupal cron job to check for changes
and invalidate affected cache items.

To invalidate the caches instantly when the data is changed on the commercetools
side, we recommend configuring the commercetools Subscription, more details
about this are on the Subscriptions tab in the module settings.


## Maintainers

- [EPAM Systems](https://www.drupal.org/epam-systems)


## Branding Note on "commercetools"

Throughout this module, "commercetools" is intentionally rendered in all
lowercase within the UI. This decision aligns with the official branding
guidelines of commercetools, which specify their name should appear in lowercase
across all partner implementations.
