/**
 * @file
 * A library to check if Bootstrap library is present on the page.
 *
 * The module itself has no direct dependency on bootstrap,
 * but some components use Bootstrap CSS for the design.
 * You can override these components and work with this module
 * without Bootstrap library at all.
 */

(function ($, Drupal) {
  Drupal.behaviors.bootstrapChecker = {
    attach: () => {
      window.onload = () => {
        const version = $.fn?.tooltip?.Constructor?.VERSION;
        if (version && parseInt(version, 10) < 4) {
          new Drupal.Message().add(
            Drupal.t(
              `Bootstrap ${version} detected, which is not supported. Please upgrade to Bootstrap 4 or newer.`,
            ),
            { type: 'warning' },
          );
        } else if (!window.bootstrap) {
          new Drupal.Message().add(
            Drupal.t(
              'This template requires a Bootstrap library for the design. Please install any <a href="https://www.drupal.org/project/project_theme?text=bootstrap">Bootstrap-compatible Drupal theme</a> or override the template using any other CSS framework.',
            ),
            { type: 'error' },
          );
        }
      };
    },
  };
})(jQuery, Drupal);
