/**
 * @file
 * The commercetools_content gallery modal functionality.
 */

(() => {
  Drupal.behaviors.commercetoolsContentGalleryModal = {
    attach(context) {
      once(
        'commercetoolsContentGalleryModal',
        '.modal-button',
        context,
      ).forEach((modalButton) => {
        modalButton.addEventListener('click', (e) => {
          e.preventDefault();
          const currentButton = e.currentTarget;
          const slide = parseInt(currentButton.dataset.slideTo, 10);
          const target = currentButton.dataset.bsTarget || '';
          const modal = document.querySelector(target);
          this.setActiveSlider(modal, slide);
        });
      });
    },

    setActiveSlider(modal, slide) {
      const items = modal.querySelectorAll('.carousel-item');
      items.forEach((item, k) => {
        item.classList.remove('active');
        if (k === slide) {
          item.classList.add('active');
        }
      });
    },
  };
})();
