<?php

namespace Drupal\commercetools_content\Controller;

use Drupal\commercetools\CommercetoolsCarts;
use Drupal\commercetools\CommercetoolsCustomers;
use Drupal\Core\Controller\ControllerBase;
use Drupal\user\UserInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Defines a controller for the Commercetools order pages.
 */
class CommercetoolsOrdersController extends ControllerBase {

  /**
   * The commercetools content carts service.
   *
   * @var \Drupal\commercetools\CommercetoolsCarts
   */
  protected CommercetoolsCarts $ctCarts;

  /**
   * The Commercetools customers service.
   *
   * @var \Drupal\commercetools\CommercetoolsCustomers
   */
  protected CommercetoolsCustomers $ctCustomers;

  /**
   * The pager manager service.
   *
   * @var \Drupal\Core\Pager\PagerManagerInterface
   */
  protected $pagerManager;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    $instance = parent::create($container);
    $instance->ctCustomers = $container->get('commercetools.customers');
    $instance->ctCarts = $container->get('commercetools.carts');
    $instance->pagerManager = $container->get('pager.manager');
    return $instance;
  }

  /**
   * Displays a page with the user's orders.
   *
   * @param \Drupal\user\UserInterface $user
   *   The user.
   *
   * @return array
   *   A render array.
   */
  public function view(UserInterface $user): array {
    $itemsPerPage = 10;
    $offset = $this->pagerManager->findPage() * $itemsPerPage;

    $customer = $this->ctCustomers->getCustomerByUser($user);
    $orderListCacheable = $this->ctCarts->getOrders(
      [
        'limit' => $itemsPerPage,
        'offset' => $offset,
        'where' => 'customerId="' . $customer['id'] . '"',
      ],
    );
    $orderList = $orderListCacheable->getData();

    $output['order_list'] = [
      '#type' => 'container',
    ];
    foreach ($orderList['results'] as $key => $order) {
      $order['customer']['uid'] = $user->id();
      $output[$key] = [
        '#theme' => 'commercetools_order_card',
        '#order' => $order,
        '#attributes' => ['class' => 'order'],
      ];
    }

    $output['pager'] = [
      '#type' => 'pager',
    ];
    $this->pagerManager->createPager($orderList['total'] ?? 0, $itemsPerPage);

    $orderListCacheable->getCacheableMetadata()->applyTo($output);
    return $output;
  }

}
