<?php

namespace Drupal\commercetools_content\EventSubscriber;

use Drupal\commercetools_content\Service\CommercetoolsAjaxHelper;
use Drupal\layout_builder\Event\SectionComponentBuildRenderArrayEvent;
use Drupal\layout_builder\LayoutBuilderEvents;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Subscribes to layout builder events to ajaxify content blocks.
 */
class CommercetoolsContentAjaxSubscriber implements EventSubscriberInterface {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    if (class_exists(LayoutBuilderEvents::class)) {
      return [
        LayoutBuilderEvents::SECTION_COMPONENT_BUILD_RENDER_ARRAY => ['onSectionComponentBuildRenderArray', 0],
      ];
    }
    return [];
  }

  /**
   * Adds class to force system main content block update.
   *
   * @param \Drupal\layout_builder\Event\SectionComponentBuildRenderArrayEvent $event
   *   The section component build render array event.
   */
  public function onSectionComponentBuildRenderArray(SectionComponentBuildRenderArrayEvent $event) {
    $build = $event->getBuild();
    // Add ajax flag class to force update for system main block.
    if (!empty($build['#configuration'][CommercetoolsAjaxHelper::COMMERCETOOLS_SYSTEM_BLOCK_FORCE_UPDATE_CONFIG])) {
      $build['#attributes'][CommercetoolsAjaxHelper::COMMERCETOOLS_SYSTEM_BLOCK_FORCE_UPDATE] = TRUE;
      $event->setBuild($build);
    }
    // Add use ajax class for blocks inside layout builder.
    if (!empty($build['#configuration']['use_ajax'])) {
      $build['#attributes'][CommercetoolsAjaxHelper::COMMERCETOOLS_AJAX_ATTRIBUTE] = TRUE;
      $build['#attributes'][CommercetoolsAjaxHelper::COMMERCETOOLS_PRODUCT_INDEX] = $build['#configuration']['product_list_index'] ?? 0;
      $event->setBuild($build);
    }
  }

}
