<?php

declare(strict_types=1);

namespace Drupal\commercetools_content\Plugin\Block;

use Drupal\commercetools\Plugin\Block\CommercetoolsCatalogActionBlockBase;
use Drupal\commercetools_content\Form\ContentSettingsForm;
use Drupal\commercetools_content\Form\ProductSearchForm;
use Drupal\Core\Cache\Cache;
use Drupal\Core\Form\FormBuilderInterface;
use Drupal\Core\Url;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a product search block.
 *
 * @Block(
 *   id = "commercetools_content_product_search",
 *   admin_label = @Translation("Product Search"),
 * )
 */
class CommercetoolsContentProductSearchBlock extends CommercetoolsCatalogActionBlockBase {

  /**
   * The form builder.
   *
   * @var \Drupal\Core\Form\FormBuilderInterface
   */
  protected FormBuilderInterface $formBuilder;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): self {
    $instance = parent::create($container, $configuration, $plugin_id, $plugin_definition);
    $instance->formBuilder = $container->get('form_builder');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function buildSafe(): array {
    $targetPage = empty($this->configuration['target_page']) ? NULL : Url::fromUserInput($this->configuration['target_page']);
    $output = [
      'form' => $this->formBuilder->getForm(ProductSearchForm::class, $this->configuration['product_list_index'], $targetPage),
    ];
    $output['form']['#attributes']['class'][] = 'container-inline';
    return $output;
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheTags(): array {
    $cacheTags = parent::getCacheTags();
    return Cache::mergeTags($cacheTags, [
      'config:' . ContentSettingsForm::CONFIGURATION_NAME,
    ]);
  }

}
