<?php

namespace Drupal\commercetools_content\Service;

use Drupal\Core\Render\MainContent\HtmlRenderer;
use Drupal\Core\Routing\RouteMatchInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Commercetools html render wrapper. Exposes private method from parent class.
 */
class CommercetoolsHtmlRenderer extends HtmlRenderer {

  /**
   * Prepares the HTML body: wraps the main content in #type 'page'.
   *
   * @param array $mainContent
   *   The render array representing the main content.
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The request object, for context.
   * @param \Drupal\Core\Routing\RouteMatchInterface $routeMatch
   *   The route match, for context.
   *
   * @return array
   *   An array with two values:
   *   0. A #type 'page' render array.
   *   1. The page title.
   *
   * @throws \LogicException
   *   If the selected display variant does not implement PageVariantInterface.
   */
  public function prepareRender(array $mainContent, Request $request, RouteMatchInterface $routeMatch) {
    return $this->prepare($mainContent, $request, $routeMatch);
  }

}
