class ProductPage extends HTMLElement {
  connectedCallback() {
    this.slug = drupalSettings.path.currentPath.replace(
      `${drupalSettings.commercetoolsDecoupled.catalogPath.substring(1)}/`,
      '',
    );
    if (!this.slug) {
      throw new Error('The current URL misses the slug parameter.');
    }
    this.renderComponent();
  }

  renderComponent() {
    this.innerHTML = /* html */ `<ct-product-info slug="${this.slug}" />`;
  }
}

customElements.define('ct-product-page', ProductPage);
