class ProductsList extends HTMLElement {
  connectedCallback() {
    const productCatalog = document.createElement('ct-product-catalog');

    Array.from(this.attributes).forEach((attr) => {
      productCatalog.setAttribute(attr.name, attr.value);
      this.removeAttribute(attr.name);
    });

    this.innerHTML = '';
    this.appendChild(productCatalog);
  }
}

customElements.define('ct-products-list', ProductsList);
