class CategoriesCardsItems extends window.commercetools.CategoriesItemsBase {
  setAttributes() {
    this.listLinkClasses = ['btn', 'btn-outline-primary', 'w-100'];
    this.itemClasses = [
      'ps-0',
      'col-12',
      'col-md-6',
      'my-2',
      `col-lg-${12 / this.componentConfig.cardsColumns}`,
    ];
    if (this.loading) {
      this.itemClasses.push('placeholderify');
    }
  }

  renderComponent() {
    const row = document.createElement('div');
    row.classList.add('row');

    const url = new URL(window.location);
    const paramName = window.commercetools.getParamNameByIndex(
      'category',
      this.componentConfig.productListIndex,
    );

    this.categoryList.forEach((item) => {
      url.searchParams.set(paramName, item.id);
      const href = url.toString();
      const link = document.createElement('a');
      link.addEventListener('click', this.linkClickHandler);
      link.setAttribute('href', href);
      link.innerText = item.name;
      link.classList.add(...this.listLinkClasses);

      const linkWrap = document.createElement('div');
      linkWrap.classList.add(...this.itemClasses);
      linkWrap.appendChild(link);

      row.appendChild(linkWrap);
    });

    const container = document.createElement('div');
    container.classList.add('container', 'py-4');
    container.appendChild(row);

    this.appendChild(container);
  }
}

customElements.define('ct-categories-cards-items', CategoriesCardsItems);
