class LineItemSummary extends HTMLElement {
  connectedCallback() {
    this.gridClasses = [['col-4 col-md-3'], ['col'], [], ['col']];
    this.renderLineItem();
  }

  renderLineItem() {
    const productPath = Drupal.url(
      `${drupalSettings.commercetoolsDecoupled.catalogPath.substring(1)}/${this.lineItem.productSlug}?sku=${this.lineItem.variant.sku}`,
    );

    const container = document.createElement('div');

    container.classList.add(
      'row',
      'd-flex',
      'justify-content-between',
      'align-items-center',
      'py-2',
    );

    container.innerHTML = `
      <div class="${this.gridClasses[0].join(' ')} text-center">
        ${!this.lineItem.variant.images ? LineItemSummary.placeholderImage() : `<img class="w-100" src="${this.lineItem.variant.images[0].url}" alt="${this.lineItem.name}"/>`}
      </div>

      <div class="${this.gridClasses[1].join(' ')}">
        <span class="placeholderify-ignore"><a class="fs-5 text-decoration-none fw-bold" href="${productPath}">${this.lineItem.name}</a></span>
        ${this.lineItem.quantity > 1 ? `<span>&Cross;${this.lineItem.quantity}</span>` : ''}
      </div>
      <div class="${this.gridClasses[3].join(' ')} text-align-right">
        ${
          this.lineItem.isDiscounted
            ? `<del>${window.commercetools.formatPrice(this.lineItem.originalTotalPrice)}</del>
               <span class="discount text-danger">
                 ${window.commercetools.formatPrice(this.lineItem.totalPrice)}
               </span>`
            : `<span>${window.commercetools.formatPrice(this.lineItem.totalPrice)}</span>`
        }
      </div>
    `;

    this.append(container);
  }

  static placeholderImage() {
    return `
      <div class="card-img-wrapper" style="aspect-ratio: 304/405;">
        <img src="" alt="" class="card-img card-img-top" style="height: 100%; object-fit: cover;" />
      </div>
    `;
  }
}

customElements.define('ct-line-item-summary', LineItemSummary);
