class LineItems extends HTMLElement {
  connectedCallback() {
    this.renderLineItems();
  }

  renderLineItems() {
    const lineItems =
      !this.lineItems && this.isLoading
        ? [
            {
              productSlug: 'slug',
              name: Drupal.t('Product name'),
              id: 'id',
              quantity: 1,
              variant: {
                sku: 'sku',
                attributes: {},
              },
              totalPrice: {
                centAmount: 10000,
                currencyCode: 'USD',
                fractionDigits: 2,
              },
            },
          ]
        : this.lineItems;

    const container = document.createElement('div');
    container.classList.add('line-items');

    if (this.isLoading) {
      container.classList.add('placeholderify');
    }
    lineItems.forEach((lineItem, k) => {
      const lineItemView =
        this.lineStyle === 'summary' ? 'ct-line-item-summary' : 'ct-line-item';
      const ctLineItem = document.createElement(lineItemView);
      ctLineItem.isLoading = this.isLoading;
      ctLineItem.lineStyle = this.lineStyle;
      ctLineItem.actionHandler = this.actionHandler;
      ctLineItem.lineItem = lineItem;
      container.append(ctLineItem);

      if (lineItems.length - 1 !== k) {
        const line = document.createElement('hr');
        line.classList.add('my-2');
        container.append(line);
      }
    });

    this.append(container);
  }
}

customElements.define('ct-line-items', LineItems);
