class CategoriesCards extends window.commercetools.CategoriesBase {
  renderComponent() {
    if (!this.loading) {
      if (this.componentConfig.initialLevel > 1) {
        const currentLevel =
          this.getActiveCategoryId() !== null
            ? this.findCategoryLevel(
                this.categoriesTree,
                this.getActiveCategoryId(),
                2,
              )
            : 1;

        if (this.componentConfig.initialLevel > currentLevel) {
          return;
        }
      }

      if (
        this.componentConfig.displayFromCurrent &&
        this.getActiveCategoryId() !== null
      ) {
        this.categoriesTree = this.getCategorySubtree(
          this.categoriesTree,
          this.getActiveCategoryId(),
          1,
        )?.children;
      }

      if (!this.categoriesTree) {
        return;
      }
    }

    const cards = document.createElement('ct-categories-cards-items');
    cards.loading = this.loading;
    cards.categoryList = this.categoriesTree;
    cards.componentConfig = this.componentConfig;
    this.innerHTML = '';
    this.appendChild(cards);
  }
}

customElements.define('ct-categories-cards', CategoriesCards);
