class CategoriesList extends window.commercetools.CategoriesBase {
  renderComponent() {
    if (!this.loading) {
      if (this.componentConfig.initialLevel !== 1) {
        const currentLevel =
          this.getActiveCategoryId() !== null
            ? this.findCategoryLevel(
                this.categoriesTree,
                this.getActiveCategoryId(),
                2,
              )
            : 1;

        if (this.componentConfig.initialLevel > currentLevel) {
          return;
        }
      }

      if (
        this.componentConfig.displayFromCurrent &&
        this.componentConfig.parentCategory
      ) {
        this.categoriesTree = this.getCategorySubtree(
          this.categoriesTree,
          this.componentConfig.parentCategory,
          100,
        ).children;
      }

      if (!this.categoriesTree) {
        return;
      }
    }

    const links = document.createElement('ct-categories-links-items');
    links.loading = this.loading;
    links.categoriesList = this.categoriesTree;
    links.componentConfig = this.componentConfig;
    links.currentTreeLevel = 1;
    this.innerHTML = '';
    this.appendChild(links);
  }
}

customElements.define('ct-categories-list', CategoriesList);
