class OrderList extends HTMLElement {
  connectedCallback() {
    const container = document.createElement('div');
    container.classList.add('container', 'commercetools-order-cards');
    const row = document.createElement('div');
    row.classList.add('row');
    container.appendChild(row);

    this.innerHTML = '';
    this.renderOrders(row).catch((error) => {
      new Drupal.Message().add(
        Drupal.t('An error occurred while loading products.'),
        {
          type: 'error',
        },
      );
      throw error;
    });

    this.appendChild(container);
  }

  async renderOrders(row) {
    row.innerHTML = '';
    this.orders.forEach((order) => {
      const orderCard = document.createElement('ct-order-card');
      orderCard.order = order;
      orderCard.isLoading = this.isLoading;
      row.appendChild(orderCard);
    });
  }
}

customElements.define('ct-order-list', OrderList);
