class ProductCards extends HTMLElement {
  connectedCallback() {
    this.productCards = [];
    const container = document.createElement('div');
    container.classList.add('container', 'commercetools-product-cards');
    const row = document.createElement('div');
    row.classList.add('row');
    container.appendChild(row);

    this.innerHTML = '';
    this.renderProducts(row).catch((error) => {
      new Drupal.Message().add(
        Drupal.t('An error occurred while loading products.'),
        {
          type: 'error',
        },
      );
      throw error;
    });

    this.appendChild(container);
  }

  setLoadingState(state) {
    this.productCards.forEach((card) => {
      card.setLoadingState(state);
    });
  }

  async renderProducts(row) {
    row.innerHTML = '';
    const bootstrapColumns = Math.floor(12 / this.columnsNumber);
    const columnClass = `col-lg-${bootstrapColumns}`;
    this.products.forEach((product) => {
      const productWrapper = document.createElement('div');
      productWrapper.classList.add(
        'col-12',
        'col-md-6',
        'my-2',
        'ps-0',
        columnClass,
      );
      const productCard = document.createElement('ct-product-card');
      productCard.product = product;
      productCard.isLoading = this.isLoading;
      this.productCards.push(productCard);
      productWrapper.appendChild(productCard);
      row.appendChild(productWrapper);
    });
  }
}

customElements.define('ct-product-cards', ProductCards);
