class ProductTitles extends HTMLElement {
  connectedCallback() {
    this.productTitles = [];
    const container = document.createElement('div');
    container.classList.add(
      'container',
      'commercetools-product-titles',
      'py-3',
    );
    const row = document.createElement('div');
    row.classList.add('row');
    container.appendChild(row);
    const ul = document.createElement('ul');
    ul.classList.add('list-group');
    row.appendChild(ul);

    this.innerHTML = '';
    this.renderProducts(ul).catch((error) => {
      new Drupal.Message().add(
        Drupal.t('An error occurred while loading products.'),
        {
          type: 'error',
        },
      );
      throw error;
    });

    this.appendChild(container);
  }

  setLoadingState(state) {
    this.productTitles.forEach((card) => {
      card.setLoadingState(state);
    });
  }

  async renderProducts(ul) {
    ul.innerHTML = '';
    this.products.forEach((product) => {
      const li = document.createElement('li');
      li.classList.add('list-group-item');
      const productTitle = document.createElement('ct-product-title');
      productTitle.product = product;
      productTitle.isLoading = this.isLoading;
      this.productTitles.push(productTitle);
      li.appendChild(productTitle);
      ul.appendChild(li);
    });
  }
}

customElements.define('ct-product-titles', ProductTitles);
