class SearchForm extends HTMLElement {
  connectedCallback() {
    const form = document.createElement('form');
    form.classList.add('commercetools-decoupled-product-search-form');
    form.classList.add('commercetools-product-search-form');
    form.classList.add('container-inline');
    form.classList.add('search-form');
    this.renderForm(form);
    this.appendChild(form);
  }

  renderForm(form) {
    form.innerHTML = `
      <div class="js-form-item js-form-type-textfield form-type-textfield js-form-item-search form-item-search form-no-label mb-3">
        <input placeholder="${Drupal.t('Product search')}" type="text" name="${this.name}" value="${this.value || ''}" size="15" maxlength="128" class="form-control">
      </div>
      <div data-drupal-selector="edit-actions" class="form-actions js-form-wrapper form-wrapper mb-3" id="edit-actions">
        <button data-drupal-selector="edit-submit" type="submit" id="edit-submit" name="op" value="${Drupal.t('Search')}" class="button button--primary js-form-submit form-submit btn btn-primary">Search</button>
      </div>
    `;

    if (this.formSubmitHandler) {
      form.addEventListener('submit', this.formSubmitHandler);
    }
  }
}

customElements.define('ct-search-form', SearchForm);
