<?php

declare(strict_types=1);

namespace Drupal\commercetools_decoupled\Plugin\Block;

use Drupal\commercetools\Plugin\Block\CommercetoolsCatalogActionBlockBase;
use Drupal\commercetools_decoupled\CommercetoolsDecoupled;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a product search block.
 *
 * @Block(
 *   id = "commercetools_decoupled_product_search",
 *   admin_label = @Translation("Product Search"),
 * )
 */
class CommercetoolsDecoupledProductSearchBlock extends CommercetoolsCatalogActionBlockBase {

  /**
   * Commercetools Decoupled main service.
   *
   * @var \Drupal\commercetools_decoupled\CommercetoolsDecoupled
   */
  protected CommercetoolsDecoupled $ctDecoupled;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): static {
    $instance = parent::create($container, $configuration, $plugin_id, $plugin_definition);
    $instance->ctDecoupled = $container->get('commercetools_decoupled');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function buildSafe(): array {
    $configuration = $this->getConfiguration();
    if (empty($configuration['product_list_index'])) {
      $configuration['product_list_index'] = 0;
    }
    return $this->ctDecoupled->addDecoupledSettings([
      '#type' => 'component',
      '#component' => 'commercetools_decoupled:search-block',
      '#props' => $configuration,
    ]);
  }

}
