<?php

declare(strict_types=1);

namespace Drupal\commercetools_decoupled_test\Controller;

use Drupal\commercetools_decoupled\Controller\DecoupledPagesController;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Defines a controller for the Commercetools Decoupled Test Summary page.
 */
class SettingsController extends DecoupledPagesController {

  /**
   * Displays a page with the list of Commercetools products.
   */
  public function settings(): JsonResponse {
    $output = parent::productCatalog();
    $settings = $output['#attached']['drupalSettings'];
    return new JsonResponse($settings);
  }

}
