const deployDemoModule = require('./deployDemoModule');
const checkAnonymousCart = require('../../../../../../tests/src/Nightwatch/Lib/checkAnonymousCart');

/**
 * Performs a smoke test for the demo functionality.
 *
 * @param {object} browser
 *   Nightwatch browser instance.
 * @param {string} module
 *   A module name to deploy.
 */
module.exports = function checkoutTestDemo(browser) {
  let catalogPrefix;
  if (browser.globals.ct.testingModuleName === 'commercetools_content') {
    catalogPrefix = 'content';
  } else if (
    browser.globals.ct.testingModuleName === 'commercetools_decoupled'
  ) {
    catalogPrefix = 'decoupled';
  } else {
    throw new Error(`Unknown module: ${browser.globals.ct.testingModuleName}`);
  }
  const catalogPath = `/commercetools-demo/${catalogPrefix}/catalog`;
  const cartPath = `/commercetools-demo/${catalogPrefix}/cart`;
  browser.perform(() => {
    deployDemoModule(browser);
    checkAnonymousCart(browser, catalogPath, cartPath);
  });
};
