/**
 * Deploys the demo configuration for a Commercetools UI module.
 *
 * Requires configured global variables:
 * - browser.globals.ct.module
 *
 * @param {object} browser
 *   Nightwatch browser instance.
 * @return {object} browser
 *   Nightwatch browser instance.
 */
module.exports = function deployDemoModule(
  browser,
  { setTheme = true, setCredentials = true, clearCredentials = false } = {},
) {
  const module = browser.globals.ct.testingModuleName;

  const demoCredentialsInstallButtonSelector = `input[name=set_demo_credentials_b2c_lifestyle]`;
  const demoCredentialsResetButtonSelector = `input[name=clear_credentials]`;

  browser
    .thLogin('admin')
    .drupalRelativeURL('/admin/config/system/commercetools/demo');

  if (setTheme) {
    browser
      .thSetConfig('system.theme', { admin: 'stark' })
      .click(`input[name=set_theme_flexistyle_bootstrap]`);
  }

  if (setCredentials) {
    browser.perform(async () => {
      const buttonElement = browser.element({
        selector: demoCredentialsInstallButtonSelector,
      });
      if (await buttonElement.getAttribute('disabled')) {
        browser.click(demoCredentialsResetButtonSelector);
      }
    });

    browser
      .click(demoCredentialsInstallButtonSelector)
      .assert.textContains(
        'body',
        'demo credentials, project - Drupal Demo: Lifestyle and Home (B2C)',
      );
  }
  if (clearCredentials) {
    browser
      .click(`input[name=clear_credentials]`)
      .assert.textContains('body', 'commercetools connection: not configured');
  }

  browser
    .click(`input[name=install_${module}]`)
    .assert.textContains('body', 'Installed with demo configuration');

  browser.getAttribute('link text', 'Open Catalog', 'href', (result) => {
    browser.globals.ct.catalogUrl = result.value;
  });

  browser.thLogout();

  return browser;
};
