const checkBadCredentialsErrors = require('../../../../../../tests/src/Nightwatch/Lib/utils/checkBadCredentialsErrors');
const deployDemoModule = require('./deployDemoModule');

/**
 * Performs a smoke test for the demo functionality.
 *
 * @param {object} browser
 *   Nightwatch browser instance.
 * @param {string} module
 *   A module name to deploy.
 */
module.exports = function testBadAuthErrors(browser) {
  browser.perform(() => {
    deployDemoModule(browser, {
      setCredentials: false,
    });
  });
  browser
    .testHelpersHttpMockSetSettings({
      context: `${browser.globals.ct.testingModuleName}:testBadAuthErrors.wrongClientSecret`,
    })
    .thSetConfig('commercetools.api', {
      client_secret: 'wrong_secret',
    })
    .thDrupalFetchURL('/commercetools-test/reset-ct-connection')
    .perform(() => {
      checkBadCredentialsErrors(browser);
    });

  browser
    .testHelpersHttpMockSetSettings({
      context: `${browser.globals.ct.testingModuleName}:testBadAuthErrors.wrongClientId`,
    })
    .thSetConfig('commercetools.api', {
      client_id: 'wrong_id',
    })
    // We had an issue with an infinite loop when the block has enabled
    // custom filters. Here is a quick test for this.
    // @todo Include this case in the demo deployment and cover the happy case
    // by tests too.
    .thSetConfig(
      `block.block.commercetools_demo_${browser.globals.ct.testingModuleName}_product_filters`,
      {
        settings: {
          customize_filters_enabled: true,
          customize_filters: [],
        },
      },
    )
    .thDrupalFetchURL('/commercetools-test/reset-ct-connection')
    .thCacheClear()
    .perform(() => {
      checkBadCredentialsErrors(browser);
    });

  browser
    .testHelpersHttpMockSetSettings({
      context: `${browser.globals.ct.testingModuleName}:testBadAuthErrors.wrongProjectKey`,
    })
    .thSetConfig('commercetools.api', {
      project_key: 'non-existing-project',
    })
    .perform(() => {
      checkBadCredentialsErrors(browser);
    });
};
