<?php

namespace Drupal\commercetools\Event;

use Drupal\Component\EventDispatcher\Event;

/**
 * Provides an updated configuration once changed.
 */
class CommercetoolsConfigurationEvent extends Event {

  /**
   * Constructs the object.
   *
   * @param array $config
   *   Commercetools configuration.
   */
  public function __construct(
    protected array $config,
  ) {
  }

  /**
   * Returns the updated configuration.
   *
   * @return array
   *   The Commercetools Message data.
   */
  public function getConfig() {
    return $this->config;
  }

}
