<?php

namespace Drupal\commercetools\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\Core\Cache\RefinableCacheableDependencyInterface;

/**
 * Allow changing query variables before execution.
 */
class CommercetoolsGraphQlOperationEvent extends Event {

  /**
   * Constructs a new class instance.
   *
   * @param null|array $variables
   *   Reference to the query variables.
   * @param bool $operationAllowed
   *   Determines whether a GraphQL query can be executed.
   * @param \Drupal\Core\Cache\RefinableCacheableDependencyInterface $cacheableMetadata
   *   A cacheable metadata object.
   * @param string $query
   *   The query string.
   */
  public function __construct(
    public ?array &$variables,
    public bool &$operationAllowed,
    public RefinableCacheableDependencyInterface $cacheableMetadata,
    public readonly string $query,
  ) {
  }

}
