<?php

namespace Drupal\commercetools\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\Core\Cache\RefinableCacheableDependencyInterface;

/**
 * Allow to change the query result after execution.
 */
class CommercetoolsGraphQlOperationResultEvent extends Event {

  /**
   * Constructs a new class instance.
   *
   * @param array $result
   *   The request result.
   * @param \Drupal\Core\Cache\RefinableCacheableDependencyInterface $cacheableMetadata
   *   A cacheable metadata object.
   * @param string $query
   *   The query string.
   * @param null|array $variables
   *   The query variables.
   */
  public function __construct(
    public array &$result,
    public RefinableCacheableDependencyInterface $cacheableMetadata,
    public readonly string $query,
    public readonly ?array $variables,
  ) {}

}
