<?php

namespace Drupal\commercetools\Event;

use Drupal\Component\EventDispatcher\Event;

/**
 * The event of successful order creation.
 */
class CommercetoolsOrderCreate extends Event {

  /**
   * Constructs a new class instance.
   *
   * @param array $order
   *   The order array.
   */
  public function __construct(public array $order) {
  }

  /**
   * Returns the order from the event.
   *
   * @return array
   *   The order array.
   */
  public function getOrder(): array {
    return $this->order;
  }

}
