#!/usr/bin/env php
<?php

/**
 * @file
 * Rechecks the assets directory to not contain redundant files.
 */

declare(strict_types=1);

// The variables will be set by the script that includes this file.
$assetsDirectory = '';
require_once 'utils.inc.php';

if (empty(getenv('CT_LOG_STORED_RESPONSES_FILE'))) {
  throw new Exception("The log file for stored response is not enabled. Configure the CT_LOG_STORED_RESPONSES_FILE environment variable.");
}

$logFile = getenv("CT_LOG_STORED_RESPONSES_FILE");

$usedHashes = get_used_hashes_from_test_helpers_log($logFile);
$storedAssets = parse_stored_assets_files($assetsDirectory);
$unusedAssets = array_diff($storedAssets['hashes'], $usedHashes);

echo "Used hashes during the tests run:" . implode("\n", $usedHashes) . "\n";

if ($unusedAssets) {
  echo "Error: detected unused test assets (" . count($unusedAssets) . " files) - remove them and rerun the pipeline.\n";
  echo "List of unused hashes:\n" . implode("\n", $unusedAssets) . "\n";
  $filesList = preg_replace('/[^\s]+/m', '\0.txt \0.metadata.yml', implode(" ", $unusedAssets));
  echo "Delete command:\nrm " . $filesList . "\n";
  exit(1);
}
if ($storedAssets['otherFiles']) {
  echo "Error: detected other files in the assets directory $assetsDirectory - remove them and rerun the pipeline.\n";
  echo "List of unused hashes:\n" . implode("\n", $storedAssets['otherFiles']) . "\n";
  $filesList = implode(" ", $storedAssets['otherFiles']);
  echo "Delete command:\nrm " . $filesList . "\n";
  exit(1);
}

echo "All stored assets are used in tests, no obsolete assets or redundant files present, all is ok.";
