const { blocks, product } = require('./selectors');
const checkUrlContainsParam = require('./utils/checkUrlContainsParam');

function checkCategoriesList(browser, catalogUrl) {
  // Ensure component exists.
  browser.waitForElementVisible(blocks.categories.component);

  // Ensure list is not empty.
  browser.waitForElementVisible(
    `${blocks.categories.component} ${blocks.categories.item}`,
  );

  // Ensure list actions affect URL params.
  browser
    .thPerformAndWaitForReRender(
      () => {
        browser.click(
          `${blocks.categories.component} ${blocks.categories.item}:first-child`,
        );
      },
      { selector: product.card.component },
    )
    .perform(() => {
      checkUrlContainsParam(browser, 'category');
    });

  // Catalog clean-up.
  browser
    .drupalRelativeURL(catalogUrl)
    .waitForElementVisible(product.card.component);
}

module.exports = checkCategoriesList;
