const checkOrderList = require('./checkOrderList');
const commerceToolsConfigs = require('./commerceToolsConfigs');
const getResponseFromLatestByDataType = require('./getResponseFromLatestByDataType');
const { order } = require('./selectors');

module.exports = function checkOrdersPage(browser, module) {
  let user;
  // Create testing customer.
  const name = 'commercetools-test-user';
  const mail = 'commercetools-test-user@example.com';
  const password = 'commercetools-test-user-password';
  const permissions = ['view own commercetools orders'];
  const ordersPagePath =
    commerceToolsConfigs[module][`${module}.settings`].user_orders_path;

  browser
    .perform(async () => {
      await browser.thCreateUser(
        { mail, name, password, permissions },
        true,
        (returnValue) => {
          user = returnValue.value;
        },
      );
    })
    .perform(async () => {
      const userOrdersPath = ordersPagePath.replace(
        '{user}',
        user.uid[0].value,
      );
      await browser
        .drupalRelativeURL(userOrdersPath)
        .waitForElementVisible(order.card.component);

      const apiResponse = await getResponseFromLatestByDataType(
        browser,
        'orders',
      );
      await checkOrderList(browser, apiResponse.value.data.orders.results);
    });
};
