// eslint-disable-next-line import/no-extraneous-dependencies
const yaml = require('yaml');
const fs = require('fs');

const config = yaml.parse(
  fs.readFileSync(
    `${
      __dirname
    }/../../../modules/commercetools_test/config/override/config.yml`,
    'utf8',
  ),
);

const selectors = {
  name: 'figure.card .card-title',
  image: 'figure.card .card-img',
  price: 'figure.card .price',
  button: 'figure.card .card-btn',
};

async function checkProductCard(browser, item, index, settings) {
  // Prepare all elements to check by.
  // The product name
  const nameEl = {
    selector: selectors.name,
    index,
  };
  // The product image
  const imageEl = {
    selector: selectors.image,
    index,
  };
  // The product price
  const priceEl = {
    selector: selectors.price,
    index,
  };
  const priceData = item.masterData
    ? item.masterData.current.masterVariant.price
    : item.masterVariant.price;
  // The product CTA button
  const btnEl = {
    selector: selectors.button,
    index,
  };

  const style = browser.globals.ct.settings.card_image_style;
  let imageUrl = item.masterData
    ? item.masterData.current.masterVariant.images[0].url
    : item.masterVariant.images[0].url;
  imageUrl = style ? imageUrl.replace(/(\.[^/.]+)$/, `-${style}$1`) : imageUrl;

  // Perform assertions.
  await browser.assert
    .textContains(
      nameEl,
      item.masterData ? item.masterData.current.name : item.name,
      `Checking the product title of item ${index}`,
    )
    .assert.attributeEquals(
      imageEl,
      'src',
      imageUrl,
      `Checking the product image of item ${index}`,
    );
  if (priceData && priceData.value) {
    await browser.assert.textContains(
      priceEl,
      new Intl.NumberFormat('en', {
        style: 'currency',
        currency: settings.currency,
      }).format(
        priceData.value.centAmount / 10 ** priceData.value.fractionDigits,
      ),
      `Checking the product price of item ${index}`,
    );
  } else {
    await browser.assert.textContains(
      priceEl,
      config['commercetools.settings'].unavailable_data_text,
      `Price not available, should display unavailable data text for item ${index}`,
    );
  }

  await browser.assert.elementPresent(
    btnEl,
    `Checking the 'Add to Cart' button of item ${index}`,
  );
}

module.exports = checkProductCard;
