const getResponseByDataTypeFromHashes = require('./getResponseByDataTypeFromHashes');

module.exports = async function getResponseFromLatestByDataType(
  browser,
  dataType,
  callback,
) {
  // @todo Add the delta parameter.
  const hashes = await browser.thGetLastRequestsHashes();
  const result = await getResponseByDataTypeFromHashes(
    browser,
    hashes,
    dataType,
  );

  if (typeof callback === 'function') {
    const self = this;
    callback.call(self, {
      status: 0,
      value: result,
    });
  }

  return result;
};
