/**
 * Checks if a commercetools store is set up.
 *
 * @param {object} browser
 *   The Nightwatch browser instance.
 * @param {object} settings
 *   An object of settings necessary for the store setup page.
 */
module.exports = function storeIsSetup(browser, settings) {
  browser
    .drupalRelativeURL('/ct-decoupled-settings')
    .waitForElementVisible('body')
    .getText('pre', (result) => {
      const config = JSON.parse(result.value);
      let settingsMatch = true;
      Object.keys(settings).forEach((key) => {
        settingsMatch = settingsMatch
          ? config.commercetoolsDecoupled[key] === settings[key]
          : false;
      });
    });
};
