const getBeforeAfterFunctions = require('../Lib/getBeforeAfterFunctions');

const statusMessagesSelector = 'div[data-drupal-messages]';
const defaultSubmitSelector = 'input[data-drupal-selector=edit-submit]';

function submitConfigForm(browser, submitSelector = defaultSubmitSelector) {
  browser
    .click(submitSelector)
    .waitForElementVisible(statusMessagesSelector)
    .assert.containsText(
      statusMessagesSelector,
      'The configuration options have been saved.',
    );
}

module.exports = {
  ...getBeforeAfterFunctions(__filename, { checkUpdates: true }),

  'Test the general settings form with updatedb': async (browser) => {
    browser
      .thLogin('admin')
      .drupalRelativeURL('/admin/config/system/commercetools')
      .click('input[data-drupal-selector=edit-test-credentials]')
      .assert.containsText(
        statusMessagesSelector,
        'Credentials are valid. Project name:',
      )
      .assert.containsText(statusMessagesSelector, 'No UI modules installed')
      .thInstallModules(['commercetools_content', 'commercetools_decoupled'])
      .click('input[data-drupal-selector=edit-submit]')
      .assert.containsText(
        statusMessagesSelector,
        'Link to the commercetools catalog configuration page:',
      )
      .assert.containsText('body', 'Product catalog main page:')
      .setValue('input#edit-client-id', 'xxx')
      .click(defaultSubmitSelector)
      .assert.containsText(
        'form p',
        'Changing the Client ID or Project ID requires migration',
      );
  },

  // Disabled due to core bug in ConfigSchemaChecker: https://www.drupal.org/node/3361423
  // 'Test the store settings form': async (browser) => {
  //   browser
  //     .thLogin('admin')
  //     .drupalRelativeURL('/admin/config/system/commercetools/store')
  //     .perform(submitConfigForm(browser));
  // },
};
