<?php

declare(strict_types=1);

namespace Drupal\Tests\commercetools\Unit;

use Drupal\commercetools\CommercetoolsApiServiceInterface;
use Drupal\commercetools_test\CommerceToolsTesting;
use Drupal\Tests\UnitTestCase;

/**
 * @coversDefaultClass \Drupal\commercetools\CommercetoolsApiService
 * @group commercetools
 */
class CommercetoolsApiServiceTest extends UnitTestCase {

  /**
   * @covers ::__construct
   * @covers ::getClient
   * @covers ::getBuilder
   */
  public function testService() {
    $testName = __CLASS__ . '::' . __FUNCTION__;
    $service = CommerceToolsTesting::getCommercetoolsApiService($testName);
    $config = \Drupal::config(CommercetoolsApiServiceInterface::CONFIGURATION_NAME);

    $projectInfo = $service->getBuilder()->get()->execute();
    $this->assertEquals($config->get('project_key'), $projectInfo->getKey());

    $builder = $service->getBuilder();
    $response = $builder->productProjections()->search()->post()->execute();

    $resultTotal = $response->getTotal();
    $this->assertGreaterThan(21, $resultTotal);

    $resultOnPage = $response->getCount();
    $this->assertEquals(20, $resultOnPage);

  }

}
