<?php

declare(strict_types=1);

namespace Drupal\Tests\commercetools\Unit;

use Drupal\commercetools\CommercetoolsLocalization;
use Drupal\test_helpers\TestHelpers;
use Drupal\Tests\UnitTestCase;

/**
 * @coversDefaultClass \Drupal\commercetools\CommercetoolsLocalization
 * @group commercetools
 */
class CommercetoolsLocalizationTest extends UnitTestCase {

  const DUMMY_PROJECT_INFO = [
    'languages' => [
      'en',
      'en-GB',
      'en-AU',
      'en-NZ',
      'en-US',
      'de-DE',
      'es-ES',
      'fr-FR',
      'it-IT',
      'pt-PT',
      'nl-NL',
      'en',
      'de',
      'fr',
    ],
    'countries' => [
      'FR',
      'GB',
      'DE',
      'US',
      'ES',
    ],
    'currencies' => [
      'EUR',
      'GBP',
      'USD',
    ],
  ];

  const DUMMY_LANGUAGES = [
    'fr',
    'en',
    'de',
    'en-gb',
    'it',
  ];

  const EXPECTED = [
    'fr' => [
      CommercetoolsLocalization::CONFIG_LANGUAGE => 'fr-FR',
      CommercetoolsLocalization::CONFIG_COUNTRY => 'FR',
      CommercetoolsLocalization::CONFIG_CURRENCY => 'EUR',
    ],
    'en' => [
      CommercetoolsLocalization::CONFIG_LANGUAGE => 'en-US',
      CommercetoolsLocalization::CONFIG_COUNTRY => 'US',
      CommercetoolsLocalization::CONFIG_CURRENCY => 'USD',
    ],
    'de' => [
      CommercetoolsLocalization::CONFIG_LANGUAGE => 'de-DE',
      CommercetoolsLocalization::CONFIG_COUNTRY => 'DE',
      CommercetoolsLocalization::CONFIG_CURRENCY => 'EUR',
    ],
    'en-gb' => [
      CommercetoolsLocalization::CONFIG_LANGUAGE => 'en-GB',
      CommercetoolsLocalization::CONFIG_COUNTRY => 'GB',
      CommercetoolsLocalization::CONFIG_CURRENCY => 'GBP',
    ],
    'it' => [
      CommercetoolsLocalization::CONFIG_LANGUAGE => 'it-IT',
      CommercetoolsLocalization::CONFIG_COUNTRY => 'FR',
      CommercetoolsLocalization::CONFIG_CURRENCY => 'EUR',
    ],
  ];

  /**
   * @covers ::__construct
   * @covers ::isInvalidProjectInfo
   * @covers ::processProjectInfo
   * @covers ::assortLanguageParameters
   * @covers ::matchParameters
   * @covers ::suggestParameters
   * @covers ::getMap
   * @covers ::getCurrencyForLocale
   * @covers ::toParametersArray
   * @covers ::flattenCurrenciesMap
   * @covers ::getPrimaryLanguage
   * @covers ::getRegion
   */
  public function testService() {
    TestHelpers::service('language_manager', initService: TRUE);
    TestHelpers::service('config.factory');
    $root = TestHelpers::getModuleRoot(CommercetoolsLocalization::class);
    /** @var \Drupal\commercetools\CommercetoolsLocalization $service */
    $service = TestHelpers::service('commercetools.localization', initService: TRUE, servicesYamlFile: $root . '/commercetools.services.yml');
    $service->languages = array_combine(self::DUMMY_LANGUAGES, self::DUMMY_LANGUAGES);

    $this->assertFalse($service->isInvalidProjectInfo(self::DUMMY_PROJECT_INFO));

    $result = $service->processProjectInfo(self::DUMMY_PROJECT_INFO);

    $this->assertNotEmpty($result);
    $this->assertCount(count(self::DUMMY_LANGUAGES), $result);
    $this->assertEquals(self::EXPECTED, $result);

  }

}
