/**
 * @file
 * The commercetools_content checkout functionality.
 */

((Drupal, drupalSettings, once, window) => {
  Drupal.behaviors.CommercetoolsContentCheckout = {
    attach(context) {
      once('commercetoolsContentCheckout', 'div.ctc-wrapper', context).forEach(
        () => {
          const sessionCookie = `${drupalSettings.commercetoolsContentCheckout.sessionCookieName}=; Max-Age=-1;`;
          const handleMessages = (message) => {
            if (message.code === 'checkout_completed') {
              document.cookie = sessionCookie;
              fetch(drupalSettings.commercetoolsContentCheckout.resetUri).then(
                (response) => {
                  if (!response.ok) {
                    throw new Error(`The current cart was reset with an error`);
                  }
                },
              );
              const orderId = message.payload.order.id;
              window.location.href = `${drupalSettings.commercetoolsContentCheckout.checkoutCompleteUri}?orderId=${orderId}&destination=${drupalSettings.commercetoolsContentCheckout.orderPathPrefix}/${orderId}`;
            } else if (message.code === 'checkout_cancelled') {
              window.location.href =
                drupalSettings.commercetoolsContentCheckout.cartUri;
            }
          };
          const config = {
            projectKey: drupalSettings.commercetoolsContentCheckout.projectKey,
            region: drupalSettings.commercetoolsContentCheckout.apiRegion,
            sessionId: drupalSettings.commercetoolsContentCheckout.sessionId,
            locale: drupalSettings.commercetoolsContentCheckout.locale,
            onInfo: handleMessages,
          };
          window.ctc('checkoutFlow', config);
        },
      );
    },
  };
})(Drupal, drupalSettings, once, window);
