<?php

namespace Drupal\commercetools_content;

use Drupal\commercetools_content\Service\CommercetoolsAjaxHelper;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Trait to add AJAX settings to commercetools content blocks.
 */
trait CommercetoolsAjaxTrait {

  use StringTranslationTrait;

  /**
   * Adds AJAX settings to the block configuration form.
   *
   * @param array $configuration
   *   The block configuration.
   *
   * @return array
   *   The form elements.
   */
  public function getFormElements(array $configuration): array {
    $form[CommercetoolsAjaxHelper::COMMERCETOOLS_SYSTEM_BLOCK_FORCE_UPDATE_CONFIG] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Update main content by AJAX'),
      '#default_value' => $configuration[CommercetoolsAjaxHelper::COMMERCETOOLS_SYSTEM_BLOCK_FORCE_UPDATE_CONFIG],
      '#description' => $this->t('When enabled, the whole main content block will be updated together with other dependent blocks on AJAX action. Use this option if blocks inside the layout builder.'),
      '#weight' => 10,
    ];
    return $form;
  }

}
