<?php

namespace Drupal\commercetools_content\Routing;

use Drupal\commercetools\Routing\UiModulesRouteProviderBase;
use Drupal\commercetools_content\Controller\CommercetoolsCatalogController;
use Drupal\commercetools_content\Controller\CommercetoolsCheckoutController;
use Drupal\commercetools_content\Controller\CommercetoolsOrderController;
use Drupal\commercetools_content\Controller\CommercetoolsOrdersController;
use Drupal\commercetools_content\Controller\CommercetoolsProductController;
use Drupal\commercetools_content\Form\CartForm;
use Drupal\commercetools_content\Form\ContentSettingsForm;

/**
 * Defines dynamic routes.
 */
class RouteProvider extends UiModulesRouteProviderBase {

  const CONFIGURATION_NAME = ContentSettingsForm::CONFIGURATION_NAME;
  const ROUTE_PREFIX = 'commercetools_content.';

  const ROUTE_CONTROLLERS = [
    self::PAGE_CATALOG_ROUTE => CommercetoolsCatalogController::class . '::view',
    self::PAGE_PRODUCT_ROUTE => CommercetoolsProductController::class . '::view',
    self::PAGE_CART_ROUTE => CartForm::class,
    self::PAGE_USER_ORDER_ROUTE => CommercetoolsOrderController::class . '::view',
    self::PAGE_USER_ORDERS_ROUTE => CommercetoolsOrdersController::class . '::view',
    self::PAGE_CHECKOUT_ROUTE => CommercetoolsCheckoutController::class . '::page',
    self::PAGE_RESET_CART_ROUTE => CommercetoolsCheckoutController::class . '::resetCart',
  ];

}
