class CheckoutPage extends HTMLElement {
  connectedCallback() {
    const sessionId = this.getAttribute('session-id');
    const sessionCookie = `${drupalSettings.commercetoolsDecoupled.sessionCookieName}=; Max-Age=-1;`;
    const handleMessages = (message) => {
      if (message.code === 'checkout_completed') {
        document.cookie = sessionCookie;
        fetch(drupalSettings.commercetoolsDecoupled.resetUri).then(
          (response) => {
            if (!response.ok) {
              throw new Error(`The current cart was reset with an error`);
            }
          },
        );
        const orderId = message.payload.order.id;
        window.location.href = `${drupalSettings.commercetoolsDecoupled.checkoutCompleteUri}?orderId=${orderId}&destination=${drupalSettings.commercetoolsDecoupled.orderPathPrefix}/${orderId}`;
      } else if (message.code === 'checkout_cancelled') {
        window.location.href = drupalSettings.commercetoolsDecoupled.cartPath;
      }
    };
    const config = {
      projectKey: drupalSettings.commercetoolsDecoupled.projectKey,
      region: drupalSettings.commercetoolsDecoupled.apiRegion,
      sessionId,
      locale: drupalSettings.commercetoolsDecoupled.locale,
      onInfo: handleMessages,
    };
    window.ctc('checkoutFlow', config);
  }
}

customElements.define('ct-checkout-page', CheckoutPage);
