class OrderPage extends HTMLElement {
  connectedCallback() {
    this.orderId = drupalSettings.path.currentPath.match(/\/([^/]+)$/)?.[1];
    if (!this.orderId) {
      throw new Error('The current URL misses the order id parameter.');
    }

    this.innerHTML = /* html */ `<ct-order-info order-id="${this.orderId}" />`;
  }
}

customElements.define('ct-order-page', OrderPage);
