class InputCheckbox extends HTMLElement {
  connectedCallback() {
    const { name, label, disabled, checked, required } = this.properties;
    const selector = name.replace(/\[(.*?)\]/g, '-$1');

    this.innerHTML = `
      <div class="form-item form-type-email form-item-${selector}">
        <input type="checkbox" id="edit-${selector}" name="${name}" ${checked ? 'checked' : ''} ${disabled ? 'disabled="disabled"' : ''} ${required ? 'required="required"' : ''} class="form-checkbox form-check-input ${required ? 'required' : ''} ${disabled ? 'disabled' : ''}">
        <label for="edit-${selector}" class="${required ? 'form-required' : ''}">${label}</label>
      </div>
    `;
  }
}

customElements.define('ct-input-checkbox', InputCheckbox);
