class Carousel extends HTMLElement {
  connectedCallback() {
    const activeSlide = this.activeSlide || 0;
    const selector = `ct-decoupled-carousel-${Math.random().toString(36).substring(2, 9)}`;

    this.innerHTML = `
      <div id="${selector}" class="carousel carousel-dark slide" data-bs-interval="false">
        ${
          this.items.length < 2
            ? ''
            : `
          <div class="carousel-indicators">
            ${this.items
              .map((i, k) => {
                return `
               <button type="button" data-bs-target="#${selector}" data-bs-slide-to="${k}" class="${k === activeSlide ? 'active' : ''}" aria-current="${k === activeSlide ? 'true' : 'false'}" aria-label="Slide ${k + 1}"></button>
             `;
              })
              .join('')}
          </div>
        `
        }

        <div class="carousel-inner">
        </div>

        ${
          this.items.length < 2
            ? ''
            : `
          <button class="carousel-control-prev" type="button" data-bs-target="#${selector}" data-bs-slide="prev">
            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
            <span class="visually-hidden">${Drupal.t('Previous')}</span>
          </button>
          <button class="carousel-control-next" type="button" data-bs-target="#${selector}" data-bs-slide="next">
            <span class="carousel-control-next-icon" aria-hidden="true"></span>
            <span class="visually-hidden">${Drupal.t('Next')}</span>
          </button>
       `
        }
      </div>
   `;

    const carouselInner = this.querySelector('.carousel-inner');
    this.items.forEach((item) => {
      const itemWr = document.createElement('div');

      itemWr.classList.add('carousel-item');
      itemWr.appendChild(item);
      carouselInner.append(itemWr);
    });
    this.setActiveSlider(activeSlide);
  }

  setActiveSlider(slide) {
    const items = this.querySelectorAll('.carousel-item');
    items.forEach((item, k) => {
      item.classList.remove('active');
      if (k === slide) {
        item.classList.add('active');
      }
    });
    this.activeSlide = slide;
  }
}

customElements.define('ct-carousel', Carousel);
