class PageNotFound extends HTMLElement {
  connectedCallback() {
    this.render();
  }

  render() {
    const pageNotFoundText = Drupal.t('Page not found');
    let isHeaderReplaced = false;
    // @todo Make a regexp to replace any Drupal-formatted token.
    document.title = document.title.replace(
      '[commercetools_product:name]',
      pageNotFoundText,
    );
    const headingElement = document.querySelector('.block-page-title-block h1');
    if (headingElement) {
      headingElement.innerText = pageNotFoundText;
      isHeaderReplaced = true;
    }
    this.innerHTML = `
      <div>
        ${isHeaderReplaced ? '' : `<h1>${pageNotFoundText}</h1>`}
        <p>${Drupal.t('The requested page could not be found.')}</p>
      </div>`;
  }
}

customElements.define('ct-page-not-found', PageNotFound);
