class ProductCard extends HTMLElement {
  connectedCallback() {
    const placeholderProduct = {
      name: 'Placeholder for title',
      slug: 'placeholder-path',
      masterVariant: {
        images: [{ url: '' }],
        price: { localizedPrice: '$1000' },
      },
      isLoading: true,
    };
    const product = this.isLoading !== true ? this.product : placeholderProduct;
    this.name = product.name;
    if (!product.slug) {
      new Drupal.Message().add(
        'The product slug value is missing for a product.',
        { type: 'error' },
      );
    }
    this.path = Drupal.url(
      `${drupalSettings.commercetoolsDecoupled.catalogPath.substring(1)}/${product.slug}`,
    );

    this.image = product?.masterVariant?.images?.[0]?.url || '';
    if (this.image) {
      this.image = window.commercetools.applyImageStyle(this.image);
    }

    this.price = product?.masterVariant?.price ?? {};
    this.isLoading = product.isLoading;

    const priceHtml = this.price?.discounted?.localizedPrice
      ? `${this.price?.localizedPrice ? `<del>${this.price.localizedPrice}</del>` : ''} <span class="discount text-danger">${this.price.discounted.localizedPrice}</span>`
      : this.price?.localizedPrice || '';

    this.innerHTML = /* html */ `
    <figure class="card h-100${this.isLoading ? ' placeholderify' : ''}">
      <a class="h-100" href="${this.path}">
        <div class="card-img-wrapper h-100 d-flex flex-wrap align-items-center" style="${
          this.isLoading ? 'aspect-ratio: 304/405; ' : ''
        }overflow: hidden;">
          <img src="${this.image}" alt="${
            this.name
          }" class="card-img card-img-top m-auto max-width ${this.isLoading ? ' h-100' : ''}" ${this.isLoading ? '' : 'style="max-height: 12rem; width: auto; max-width: 100%"'} />
        </div>
      </a>
      <div class="card-body">
        <h2 class="card-title fs-5 text-truncate text-primary"><a class="text-decoration-none" href="${
          this.path
        }">${this.name}</a></h2>
      </div>
      <div class="card-footer bg-transparent">
        <a href="${this.path}" class="card-btn btn btn-primary btn-sm float-end">${Drupal.t('Details')}</a>
        ${priceHtml ? `<span class="price">${priceHtml}</span>` : ''}
      </div>
    </figure>
    `;
  }

  setLoadingState(state = null) {
    const stateClasses = {
      load: 'placeholderify',
      reload: 'reloadify',
    };

    this.querySelectorAll('figure.card').forEach((card) => {
      card.classList.remove(...Object.values(stateClasses));
      const stateClass = stateClasses[state];
      if (state !== null && stateClass) {
        card.classList.add(stateClass);
      }
    });
  }
}

customElements.define('ct-product-card', ProductCard);
